/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.UUID;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.block.IOwnerProtected;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SafeBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.KeyLockableTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.OpeneableContainerBlockEntity;
import net.mehvahdjukaar.supplementaries.common.inventories.IContainerProvider;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1733;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class SafeBlockTile
extends OpeneableContainerBlockEntity
implements IOwnerProtected {
    private String password = null;
    private String ownerName = null;
    private UUID owner = null;

    public SafeBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.SAFE_TILE.get(), pos, state, 27);
    }

    public boolean canPlayerOpen(class_1657 player, boolean feedbackMessage) {
        if (player == null || player.method_7337()) {
            return true;
        }
        if (CommonConfigs.Functional.SAFE_SIMPLE.get().booleanValue()) {
            if (this.isNotOwnedBy(player)) {
                if (feedbackMessage) {
                    player.method_7353((class_2561)class_2561.method_43469((String)"message.supplementaries.safe.owner", (Object[])new Object[]{this.ownerName}), true);
                }
                return false;
            }
        } else {
            return KeyLockableTile.doesPlayerHaveKeyToOpen(player, this.password, feedbackMessage, "safe");
        }
        return true;
    }

    public boolean method_17489(class_1657 pPlayer) {
        return this.canPlayerOpen(pPlayer, false);
    }

    public String getPassword() {
        return this.password;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        if (this.field_11863 != null) {
            class_1657 p;
            if (owner != null && (p = this.field_11863.method_18470(owner)) != null) {
                this.ownerName = p.method_5477().getString();
            }
            this.method_5431();
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        }
    }

    public void clearOwner() {
        this.ownerName = null;
        this.owner = null;
        this.password = null;
    }

    public class_2561 method_5476() {
        if (CommonConfigs.Functional.SAFE_SIMPLE.get().booleanValue()) {
            if (this.ownerName != null) {
                return class_2561.method_43469((String)"gui.supplementaries.safe.name", (Object[])new Object[]{this.ownerName, super.method_5476()});
            }
        } else if (this.password != null) {
            return class_2561.method_43469((String)"gui.supplementaries.safe.password", (Object[])new Object[]{this.password, super.method_5476()});
        }
        return super.method_5476();
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"block.supplementaries.safe");
    }

    @Override
    protected void playOpenSound(class_2680 state) {
        class_2382 vec3i = ((class_2350)state.method_11654((class_2769)SafeBlock.FACING)).method_10163();
        double d0 = (double)this.field_11867.method_10263() + 0.5 + (double)vec3i.method_10263() / 2.0;
        double d1 = (double)this.field_11867.method_10264() + 0.5 + (double)vec3i.method_10264() / 2.0;
        double d2 = (double)this.field_11867.method_10260() + 0.5 + (double)vec3i.method_10260() / 2.0;
        this.field_11863.method_43128(null, d0, d1, d2, class_3417.field_15082, class_3419.field_15245, 0.5f, this.field_11863.field_9229.method_43057() * 0.1f + 0.65f);
    }

    @Override
    protected void playCloseSound(class_2680 state) {
        class_2382 vec3i = ((class_2350)state.method_11654((class_2769)SafeBlock.FACING)).method_10163();
        double d0 = (double)this.field_11867.method_10263() + 0.5 + (double)vec3i.method_10263() / 2.0;
        double d1 = (double)this.field_11867.method_10264() + 0.5 + (double)vec3i.method_10264() / 2.0;
        double d2 = (double)this.field_11867.method_10260() + 0.5 + (double)vec3i.method_10260() / 2.0;
        this.field_11863.method_43128(null, d0, d1, d2, class_3417.field_15131, class_3419.field_15245, 0.5f, this.field_11863.field_9229.method_43057() * 0.1f + 0.65f);
    }

    @Override
    protected void updateBlockState(class_2680 state, boolean open) {
        this.field_11863.method_8652(this.method_11016(), (class_2680)state.method_11657((class_2769)SafeBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.owner = tag.method_10545("Owner") ? tag.method_25926("Owner") : null;
        if (tag.method_10545("OwnerName")) {
            this.ownerName = tag.method_10558("OwnerName");
        } else {
            this.owner = null;
        }
        this.password = tag.method_10545("Password") ? tag.method_10558("Password") : null;
    }

    @Override
    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        this.saveOwner(compound);
        if (this.ownerName != null) {
            compound.method_10582("OwnerName", this.ownerName);
        }
        if (this.password != null) {
            compound.method_10582("Password", this.password);
        }
    }

    public boolean method_5437(int index, class_1799 stack) {
        return MiscUtils.isAllowedInShulker(stack);
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        return false;
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return false;
    }

    public class_1703 method_5465(int id, class_1661 player) {
        return new SafeContainerMenu(id, player, (class_1263)this);
    }

    private static class SafeContainerMenu
    extends class_1733
    implements IContainerProvider {
        private final class_1263 container;

        public SafeContainerMenu(int id, class_1661 inventory, class_1263 container) {
            super(id, inventory, container);
            this.container = container;
        }

        @Override
        public class_1263 getContainer() {
            return this.container;
        }
    }
}

